
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   DATUMS.C - Datum Support (Moldensky model)
// 
//
//   DESCRIPTION
//
//   Function to transform current (WGS-84) geodetic position to another
//   specified datum.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\DATUMS.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:44:12   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:33:32   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:04:56   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:07:30   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:52:26   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <graph.h>
#include <math.h>

#include "LABMON.H"
#include "monmisc.h" 

extern double        lat, lon, alt;
extern short         cmdline;
double               delta_lat;
double               delta_lon;
double               delta_alt;
extern char          buff[80];

void Molodensky(short datum)
{
       double dx, dy, dz, da, df;
       double a, b, e, f;
       double rn, rm;      
       char   *datum_name;
       double coslat, coslon, sinlat, sinlon;       
       double term1, term2,term3;
       
      /********************************************************************
       * Compute the trigonomtric sine and cosine of the latitude and the *
       * longitude because they are used numerous times in the formulas.  *
       ********************************************************************/
     
       sinlat = sin(lat);           // in radians
       sinlon = sin(lon);
       coslat = cos(lat);
       coslon = cos(lon);

       switch(datum){
         case 1:
                 datum_name = "Adindan";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = -162;  
                 dy = -12;  
                 dz = 206;
                 break;     
                 
         case 2:
                 datum_name = "AFG";
                 da = -108;  
                 df = 0.00480795;  
                 dx = -43;  
                 dy = -163;  
                 dz = 45;
                 break;
                 
         case 3:
                 datum_name = "AIN EL ABD 1970";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -150;  
                 dy = -251;      
                 dz = -2;
                 break;

         case 4:
                 datum_name = "Anna 1 Astro 1965";
                 da = -23;  
                 df = -0.00081204;  
                 dx = -491;  
                 dy = -22;  
                 dz = 435;
                 break;
 
         case 5:
                 datum_name = "ARC 1950";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = -143;  
                 dy = -90;  
                 dz = -294;
                 break;        

         case 6:
                 datum_name = "ARC 1960";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = -160;      
                 dy = -8;  
                 dz = -300;
                 break;

         case 7:
                 datum_name = "Ascension Island 1958";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -207;  
                 dy = 107;  
                 dz = 52;
                 break;         

         case 8:
                 datum_name = "Astro Beacon 'E'";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 145;  
                 dy = 75;  
                 dz = -272;
                 break;

         case 9:
                 datum_name = "Astro B4 SOR. ATOLL";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 114;  
                 dy = -116;  
                 dz = -333;
                 break;

         case 10:
                 datum_name = "Astro POS 71/4";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -320;  
                 dy = 550;  
                 dz = -494;
                 break;

         case 11:
                 datum_name = "Astronomic Station 1952";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 124;  
                 dy = -234;  
                 dz = -25;
                 break;

         case 12:
                 datum_name = "Australian Geodetic 1966";
                 da = -23;  
                 df = -0.00081204;  
                 dx = -133;  
                 dy = -48;  
                 dz = 148;
                 break;        

         case 13:
                 datum_name = "Australian Geodetic 1984";
                 da = -23;  
                 df = -0.00081204;  
                 dx = -134;      
                 dy = -48;  
                 dz = 149;
                 break;

         case 14:
                 datum_name = "Bellevue (IGN)";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -127;  
                 dy = -769;  
                 dz = 472;
                 break;        

         case 15:
                 datum_name = "Bermuda 1957";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = -73;  
                 dy = 213;  
                 dz = 296;
                 break;

         case 16:
                 datum_name = "Bogota Observatory";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 307;  
                 dy = 304;  
                 dz = -318;
                 break;        

         case 17:
                 datum_name = "Campo Inchauspe";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -148;  
                 dy = 136;  
                 dz = 90;
                 break;

         case 18:
                 datum_name = "Canton Island 1966";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 298;  
                 dy = -304;  
                 dz = -375;
                 break;         

         case 19:
                 datum_name = "Cape";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = -136;  
                 dy = -108;  
                 dz = -292;
                 break;        

         case 20:
                 datum_name = "Cape Canaveral";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = -2;  
                 dy = 150;  
                 dz = 181;
                 break;         

         case 21:
                 datum_name = "Carthage";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = -263;  
                 dy = 6;  
                 dz = 431;
                 break;         

         case 22:
                 datum_name = "Chatham 1971";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 175;  
                 dy = -38;  
                 dz = 113;
                 break;        

         case 23:
                 datum_name = "Chua Astro";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -134;  
                 dy = 229;  
                 dz = -29;
                 break;        

         case 24:
                 datum_name = "Corrego Alegre";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -206;  
                 dy = 172;  
                 dz = -6;
                 break;        

         case 25:
                 datum_name = "Djakarta (Batavia)";
                 da = 7390845;  
                 df = 0.10037483;  
                 dx = -377;  
                 dy = 681;  
                 dz = -50;
                 break;

         case 26:
                 datum_name = "DOS 1968";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 230;  
                 dy = -199;  
                 dz = -752;
                 break;         

         case 27:
                 datum_name = "Easter Island 1967";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 211;  
                 dy = 147;  
                 dz = 111;
                 break;         

         case 28:
                 datum_name = "European 1950";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -87;  
                 dy = -98;  
                 dz = -121;
                 break;        

         case 29:
                 datum_name = "European 1979";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -86;  
                 dy = -98;  
                 dz = -119;
                 break;        

         case 30:
                 datum_name = "Gandajika Base";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -133;  
                 dy = -321;  
                 dz = 50;
                 break;

         case 31:
                 datum_name = "Geodetic Datum 1949";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 84;  
                 dy = -22;  
                 dz = 209;
                 break;

         case 32:
                 datum_name = "Guam 1963";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = -100;  
                 dy = -248;  
                 dz = 259;
                 break;

         case 33:
                 datum_name = "GUX 1 Astro";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 252;  
                 dy = -209;  
                 dz = -751;
                 break;

         case 34:
                 datum_name = "Hjorsey 1955";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -73;  
                 dy = 46;  
                 dz = -86;
                 break;

         case 35:
                 datum_name = "Hong Kong 1963";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -156;  
                 dy = -271;  
                 dz = -189;
                 break;         

         case 36:
                 datum_name = "Indian Thailand ";
                 da = 860.655;  
                 df = 0.28361368;  
                 dx = 214;  
                 dy = 836;  
                 dz = 303;
                 break;         

         case 37:
                 datum_name = "Indian Bangladesh";
                 da = 860.655;  
                 df = 0.28361368;  
                 dx = 289;  
                 dy = 734;  
                 dz = 257;
                 break;        

         case 38:
                 datum_name = "Ireland 1965";
                 da = 796.811;  
                 df = 0.11960023;  
                 dx = 506;  
                 dy = -122;  
                 dz = 611;
                 break;        

         case 39:
                 datum_name = "ISTS 073 Astro 1969";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 208;  
                 dy = -435;  
                 dz = -229;
                 break;        

         case 40:
                 datum_name = "Johnston Island 1961";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 191;  
                 dy = -77;  
                 dz = -204;
                 break;        

         case 41:
                 datum_name = "Kandawala";
                 da = 860.655;  
                 df = 0.28361368;  
                 dx = -97;  
                 dy = 787;  
                 dz = 86;
                 break;

         case 42:
                 datum_name = "Kerguelen Island";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 145;  
                 dy = -187;  
                 dz = 103;
                 break;

         case 43:
                 datum_name = "Kertau 1948";
                 da = 832.937;  
                 df = 0.28361368;  
                 dx = -11;  
                 dy = 851;  
                 dz = 5;
                 break;        

         case 44:
                 datum_name = "La Reunion";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 94;  
                 dy = -948;  
                 dz = -1262;
                 break;        

         case 45:
                 datum_name = "L.C. 5 Astro ";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = 42;  
                 dy = 124;  
                 dz = 147;
                 break;        

         case 46:
                 datum_name = "Liberia 1964";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = -90;  
                 dy = 40;  
                 dz = 88;
                 break;         

         case 47:
                 datum_name = "Luzon";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = -133;  
                 dy = -77;  
                 dz = -51;
                 break;        

         case 48:
                 datum_name = "Mindanao Island";
                 da = -69.4;  
                 df = -.37264639;  
                 dx = -133;  
                 dy = -79;  
                 dz = -72;
                 break;

         case 49:
                 datum_name = "Mahe 1971";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = 41;  
                 dy = -220;  
                 dz = -134;
                 break;         

         case 50:
                 datum_name = "Marco Astro ";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -289;  
                 dy = -124;  
                 dz = 60;
                 break;        

         case 51:
                 datum_name = "Massawa";
                 da = 739.845;  
                 df = 0.10037483;  
                 dx = 639;  
                 dy = 405;  
                 dz = 60;
                 break;         

         case 52:
                 datum_name = "Merchich";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = 31;  
                 dy = 146;  
                 dz = 47;
                 break;
 
         case 53:
                 datum_name = "Midway Astro 1961";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 912;  
                 dy = -58;  
                 dz = 1227;
                 break;         

         case 54:
                 datum_name = "Minna";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = -92;  
                 dy = -93;  
                 dz = 122;
                 break;        

         case 55:
                 datum_name = "Nahrwan Masirah Island";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = -247;  
                 dy = -148;  
                 dz = 369;
                 break;        

         case 56:
                 datum_name = "Nahrwan United Arab Emirates";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = -249;  
                 dy = -156;  
                 dz = 381;
                 break;         

         case 57:
                 datum_name = "Nahrwan Saudia Arabia";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = -231;  
                 dy = -196;  
                 dz = 482;
                 break;

         case 58:
                 datum_name = "Namibia";
                 da = 653.135;  
                 df = 0.10037483;  
                 dx = 616;  
                 dy = 97;  
                 dz = -251;
                 break;        

         case 59:
                 datum_name = "Naparima, BWI";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -2;  
                 dy = 374;  
                 dz = 172;
                 break;

         case 60:
                 datum_name = "NAD-27 Conus";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = -8;  
                 dy = 160;  
                 dz = 176;
                 break;

         case 61:
                 datum_name = "NAD-27 Alaska";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = -5;  
                 dy = 135;  
                 dz = 172;
                 break;

         case 62:
                 datum_name = "NAD-27 Bahamas";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = -4;  
                 dy = 154;  
                 dz = 178;
                 break;        

         case 63:
                 datum_name = "NAD-27 San Salvador Island";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = 1;  
                 dy = 140;  
                 dz = 165;
                 break;

         case 64:
                 datum_name = "NAD-27 Canada";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = -10;  
                 dy = 158;  
                 dz = 187;
                 break;         

         case 65:
                 datum_name = "NAD-27 Canal Zone";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = 0;  
                 dy = 125;  
                 dz = 201;
                 break;        

         case 66:
                 datum_name = "NAD-27 Caribbean";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = -7;  
                 dy = 152;  
                 dz = 178;
                 break;         

         case 67:
                 datum_name = "NAD-27 Central America";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = 0;  
                 dy = 125;  
                 dz = 194;
                 break;         

         case 68:
                 datum_name = "NAD-27 Cuba";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = -9; 
                 dy = 152;  
                 dz = 178;
                 break;

         case 69:
                 datum_name = "NAD-27 Greenland";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = 11;  
                 dy = 114;  
                 dz = 195;
                 break;         

         case 70:
                 datum_name = "NAD-27 Mexico";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = -12;  
                 dy = 130;  
                 dz = 190;
                 break;         

         case 71:
                 datum_name = "North America 1983";
                 da = 0;  
                 df = -0.00000016;  
                 dx = 0;  
                 dy = 0;  
                 dz = 0;
                 break;         

         case 72:
                 datum_name = "Observatorio 1966";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -425;
                 dy = -169;  
                 dz = 81;
                 break;         

         case 73:
                 datum_name = "Old Egyptian 1930";
                 da = -63;  
                 df = 0.00480795;  
                 dx = -130;  
                 dy = 110;  
                 dz = -13;
                 break;         

         case 74:
                 datum_name = "Old Hawaiian";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = 61;  
                 dy = -285;  
                 dz = -181;
                 break;         

         case 75:
                 datum_name = "Oman";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = -346;  
                 dy = -1;  
                 dz = 224;
                 break;

         case 76:
                 datum_name = "Ordinance Survey of Great Britain";
                 da = 573.604;  
                 df = 0.11960023;  
                 dx = 375;  
                 dy = -111;  
                 dz = 431;
                 break;        

         case 77:
                 datum_name = "Pico de las Nieves";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -307;  
                 dy = -92;  
                 dz = 127;
                 break;        

         case 78:
                 datum_name = "Pitcairn Astro 1967";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 185;  
                 dy = 165;  
                 dz = 42;
                 break;

         case 79:
                 datum_name = "Provisional South Chilean 1963";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 16;  
                 dy = 196;  
                 dz = 93;
                 break;         

         case 80:
                 datum_name = "Provisional South American 1956";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -288;  
                 dy = 175;  
                 dz = -376;
                 break;         

         case 81:
                 datum_name = "Puerto Rico";
                 da = -69.4;  
                 df = -0.37264639;  
                 dx = 11;  
                 dy = 72;  
                 dz = -101;
                 break;        

         case 82:
                 datum_name = "Qatar National";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -128;  
                 dy = -283;  
                 dz = 22;
                 break;        

         case 83:
                 datum_name = "Qornoq";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 164;  
                 dy = 138;  
                 dz = -189;
                 break;         

         case 84:
                 datum_name = "Rome 1940";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -225;  
                 dy = -65;  
                 dz = 9;
                 break;        

         case 85:
                 datum_name = "Santa Braz";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -203;  
                 dy = 141;  
                 dz = 53;
                 break;

         case 86:
                 datum_name = "Santo (DOS)";
                 da = -251;  
                 df = -0.14192702;  
                 dx = 170;  
                 dy = 42;  
                 dz = 84;
                 break;

         case 87:
                 datum_name = "Sapper Hill 1943";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -355;  
                 dy = 16;  
                 dz = 74;
                 break;        

         case 88:
                 datum_name = "South American 1969";
                 da = -23;  
                 df = -0.00081204;  
                 dx = -57;  
                 dy = 1;  
                 dz = -41;
                 break;         

         case 89:
                 datum_name = "South Asia";
                 da = -18;  
                 df = 0.00480795;  
                 dx = 7;  
                 dy = -10;  
                 dz = -26;
                 break;

         case 90:
                 datum_name = "Southeast Base";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -499;  
                 dy = -249;  
                 dz = 314;
                 break;

         case 91:
                 datum_name = "Southwest Base";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -104;  
                 dy = -167;  
                 dz = -38;
                 break;

         case 92:
                 datum_name = "Timbalai 1948";
                 da = 860.655;  
                 df = 0.28361368;  
                 dx = -689;  
                 dy = 691;  
                 dz = -46;
                 break;

         case 93:
                 datum_name = "Tokyo";
                 da = 739.845;  
                 df = 0.10037483;  
                 dx = -128;  
                 dy = 481;  
                 dz = 664;
                 break;

         case 94:
                 datum_name = "Tristan Astro 1968";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -632;  
                 dy = 438;  
                 dz = -609;
                 break;

         case 95:
                 datum_name = "Viti Levu 1916";
                 da = -112.145;  
                 df = -0.54750714;  
                 dx = 51;  
                 dy = 391;  
                 dz = -36;
                 break;

         case 96:
                 datum_name = "Wake-Eniwetok 1960";
                 da = -133;  
                 df = -0.14192702;  
                 dx = 101;  
                 dy = 52;  
                 dz = -39;
                 break;

         case 97:
                 datum_name = "Zanderij";
                 da = -251;  
                 df = -0.14192702;  
                 dx = -265;  
                 dy = 120;  
                 dz = -358;
                 break;

          default:
                 datum_name = "WGS-84";
                 datum = 0;
                 da = 0;  
                 df = 0;  
                 dx = 0;  
                 dy = 0;  
                 dz = 0;
                 break;
          }
         
      sprintf(buff,"DATUM SET TO %s", datum_name);
      clear_message_line();
      _settextposition(cmdline,1); _outtext( buff );

      df /= 10000.0;                   // Don't forget about the scale factor


      /********************************************************************
       * Use the Delta A given in the transformation tables, Page 7-22 of *
       * the WGS-84 definition document.                                  *
       * The a used in the Molodensky formulas is that of the source datum*
       * It can be calulated from delta a and the a from the WGS-84       *
       * definition using:      da = a(WGS-84) - a(local)            *
       ********************************************************************/
     
       a = 6378137.0 - da;
     
      /********************************************************************
       * Do the same for f to get the flattening                          *
       ********************************************************************/
     
       f =  0.00335281066474 - df;
     
      /********************************************************************
       * B can be calculated from the flattening using the equations from *
       * page 7-9 of the WGS-84 defintion document.                       *
       ********************************************************************/
     
       b = (1.0 - f) * a;
     
      /********************************************************************
       * Compute the eccentricity from the flattening.                    *
       ********************************************************************/
     
       e = sqrt(f*(2.0 - f));
     
      /********************************************************************
       * Calculate Rn and Rm from the formulas on page 7-9 of the WGS-84  *
       * definition document.                                             *
       ********************************************************************/
     
       rn = a / sqrt(1.0 - pow(e * sinlat, 2));
       term1 = 1.0 - pow(e * sinlat, 2);
       term2 = pow (term1, 1.5);
       rm = (a * (1.0 - (e * e))) / term2;
     
      /********************************************************************
       * Compute the delta latitude (in radians). First compute some      *
       * of the intermediate terms and then do the summation.             *
       ********************************************************************/

       term1 = -(dx * sinlat * coslon);
       term2 = -(dy * sinlat * sinlon);
       term3 = dz * coslat;
       term1 += term2 + term3;
       term2 = (da * rn * (e * e) * sinlat * coslat) / a;
       term1 += term2;
       term2 = (rm * (a/b)) + (rn * (b/a));
       term3 = df * term2 * sinlat * coslat;
       term1 += term3;
       term2 = 1.0 /(rm + alt);

       delta_lat = term1 * term2;
   
      /********************************************************************
       * Compute the delta longitude (in radians). First compute some     *
       * of the intermediate terms and then do the summation.             *
       ********************************************************************/

       term1 = (-dx * sinlon) + (dy * coslon);
       term2 = 1.0 / ((rn + alt) * coslat);
    
       delta_lon = term1 * term2 ;
    
      /********************************************************************
       * Compute the delta height above ellipsoid (in meters). First,     *
       * compute some of the intermediate terms and then do the summation.*
       ********************************************************************/
    
       term1 = dx * coslat * coslon;
       term2 = dy * coslat * sinlon;
       term3 = dz * sinlat;
       term1 += term2 + term3;
       term2 = -da * (a / rn);
       term3 = df * (b/a) * rn * sinlat * sinlat;

       delta_alt = term1 + term2 + term3;
}

